/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItem {
    public Item item;
    public int metadata;

    public static ComparableItem fromItemStack(ItemStack itemStack) {
        return new ComparableItem(itemStack);
    }

    protected ComparableItem() {
        this.item = null;
        this.metadata = 0;
    }

    public ComparableItem(Item item, int n) {
        this.item = item;
        this.metadata = n;
    }

    public ComparableItem(ItemStack itemStack) {
        if (itemStack != null) {
            this.item = itemStack.getItem();
            this.metadata = ItemHelper.getItemDamage(itemStack);
        } else {
            this.item = null;
            this.metadata = 0;
        }
    }

    public ComparableItem(ComparableItem comparableItem) {
        this.item = comparableItem.item;
        this.metadata = comparableItem.metadata;
    }

    public ComparableItem set(ItemStack itemStack) {
        if (itemStack != null) {
            this.item = itemStack.getItem();
            this.metadata = ItemHelper.getItemDamage(itemStack);
        } else {
            this.item = null;
            this.metadata = 0;
        }
        return this;
    }

    protected final int getId() {
        return Item.getIdFromItem((Item)this.item);
    }

    public boolean isEqual(ComparableItem comparableItem) {
        if (comparableItem == null) {
            return false;
        }
        if (this.metadata == comparableItem.metadata) {
            if (this.item == comparableItem.item) {
                return true;
            }
            if (this.item != null && comparableItem.item != null) {
                return this.item.delegate.get() == comparableItem.item.delegate.get();
            }
        }
        return false;
    }

    public ComparableItem clone() {
        return new ComparableItem(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItem)) {
            return false;
        }
        return this.isEqual((ComparableItem)object);
    }

    public int hashCode() {
        return this.metadata & 0xFFFF | this.getId() << 16;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append('@').append(System.identityHashCode(this)).append('{');
        stringBuilder.append("m:").append(this.metadata).append(", i:").append(this.item == null ? null : this.item.getClass().getName());
        stringBuilder.append('@').append(System.identityHashCode(this.item)).append(", v:");
        stringBuilder.append(this.getId()).append('}');
        return stringBuilder.toString();
    }
}

